using System;
using System.IO;
using System.Net;
using System.Xml;
using System.Collections;
using System.Diagnostics;
using System.Net.Sockets;
using System.Runtime.Remoting;
using System.Runtime.Serialization.Formatters.Soap;

using Team_Project.Elements;
using Team_Project.Exceptions;
using Team_Project.PersistencyManagers;
using Team_Project.PersistencyManagers.Storages;

namespace Team_Project.PersistencyManagers.Protocols
{
	[TeamProjectInit]
	public class DistributedLockProtocol : DistribuitedSimpleProtocol
	{
		public static object ComponentInit()
		{
			MessageListener llt = (MessageListener)Globals.Instance.Data["MessageListener"];
			llt.RegisterListener("LK_REQ",typeof(LockHandlerThread));
			llt.RegisterListener("LK_OVERRIDE",typeof(LockHandlerThread));
			llt.RegisterListener("LK_CONFIRM",typeof(LockHandlerThread));
			return null;
		}

		public DistributedLockProtocol(string proj,Type ElementType, XmlNode cfg) :base(proj,ElementType, cfg)
		{}

		#region IPersistencyProtocol Members

		public override string Name
		{
			get{return "DistributedLockProtocol";}
		}

		public override IProjectElement Retrive(string location, string name, Type elementType)
		{
			if(!QueryElementExists(location,name))
				return null;
			IProjectElement el = (IProjectElement)Activator.CreateInstance(elementType,new object[] {project,location,name});
			IStorage lclStorage = Globals.Instance.Storages.GetStorageFor(project,elementType);
			Globals.Instance.Mutexes.RequestRead(project,location,name);
			try
			{el.LoadFrom(lclStorage);}
			finally
			{
				Globals.Instance.Mutexes.ReleaseRead(project,location,name);
			}
			return el;
		}
		#endregion

		protected LockElement CheckPriority(IStorage lcl,LockElement el,string source)
		{
			LockElement l = new LockElement(this.project,el.Location,el.Name);
			l.LoadFrom(lcl);
			/*if(l.RequestID == el.RequestID && source != string.Empty)
			{
				Trace.WriteLine("CheckPriority: Sending confrim for " + el.RequestID);
				ConfirmHandler.SendConfirm(source,el.RequestID);
				return;
			}*/
			CopiesTreeManager ctm = (CopiesTreeManager)Globals.Instance.Data["TreeManager"];
			if(ctm.ComparePriority(l.RequesterCopyName,el.RequesterCopyName) < 0)
			{
				Trace.WriteLine("CheckPriority: Lock comparrison lost. Throwing Exception");
				throw new LockOverriddenException(l);
			}
			Trace.WriteLine("CheckPriority: Lock comparrison Won by " + el.RequestID);
			return l;
		}

		#region IDistribuitedPersistencyProtocol Members
		public override void Store(IProjectElement el,string source)
		{
			Trace.Write("Try to lock " + el.FullName + "["+el.GetType().Name + "]");
			Trace.WriteLine(" from " + (source!=string.Empty?source:"local"));
			IStorage lclStorage = Globals.Instance.Storages.GetStorageFor(project,el.GetType());
			LockElement overrided = null;
			lock(lclStorage)
			{
				if(lclStorage.Exists(el.Location,el.Name+el.Suffix))
				{
					overrided = CheckPriority(lclStorage,(LockElement)el,source);
				}
				Globals.Instance.Mutexes.RequestWrite(project,el.Location+ "||" + el.GetType().Name,el.Name);
				try
				{
					el.WriteTo(lclStorage);
				}
				finally
				{
					Globals.Instance.Mutexes.ReleaseWrite(project,el.Location+ "||" + el.GetType().Name,el.Name);
				}
			}
			CopiesTreeManager ctm = (CopiesTreeManager)Globals.Instance.Data["TreeManager"];
			ArrayList copies = new ArrayList(ctm.GetChildren());
			if(ctm.GetParent() != string.Empty)
				copies.Add(ctm.GetParent());
			copies.Remove(source);
			if(overrided == null || source == string.Empty)
			{
				LockElement overrider;
				bool ok = ConfirmHandler.SendRequestAndWaitConfirms(copies,(LockElement)el,out overrider);
				if(!ok)
				{
					throw new LockOverriddenException(overrider);
				}
				if(source != string.Empty)
					ConfirmHandler.SendConfirm(source,((LockElement)el).RequestID);
			}
			else
			{
				bool ok = ConfirmHandler.SendOverrideAndWaitConfirms(copies,overrided,(LockElement)el);
				if(!ok)
				{
					Trace.WriteLine(Name + ": Another override received (ov 2 ov)");
				}
			}
		}
		#endregion
	}
}
